/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2010 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package com.genesyslab.samples.interceptor;

/**
 * This class is used to implement the behavior that must be executed when an alarm (according with threshold set in GSD) raised
 * In this sample the behavior consists in calling a primitive of the AlarmFileManager that writes 
 * resource (which an alarm relates to) attributes, data item id (for which an alarm triggered) and an alarm level in a plain text file.
 * In configuration file interceptor.xml it is configured in this XML fragment:
 *      <interceptor name="ALARM" implementation-class="com.genesyslab.samples.interceptor.AlarmInterceptor" method="onAlarm">
 *        	<interceptor:property name="resourceDBID" />
 *	        <interceptor:property name="resourceName" />
 *        	<interceptor:property name="resourceType" />
 * 		    <interceptor:property name="dataItemID" />
 *        	<interceptor:property name="level" />
 *      </interceptor>
 */
public class AlarmInterceptor {

    private Integer resourceDBID;
    private String resourceName;
    private Integer resourceType;
    private String dataItemID;
    private Integer level;
    
    /**
     * Called by interceptor framework prior to call to "onAlarm" method.
     * This is a standard attribute.
     */    
	public void setResourceDBID(Integer resourceDBID) {
		this.resourceDBID = resourceDBID;
	}

    /**
     * Called by interceptor framework prior to call to "onAlarm" method.
     * This is a standard attribute.
     */	
	public void setResourceName(String resourceName) {
		this.resourceName = resourceName;
	}

    /**
     * Called by interceptor framework prior to call to "onAlarm" method.
     * This is a standard attribute.
     */
	public void setResourceType(Integer resourceType) {
		this.resourceType = resourceType;
	}

    /**
     * Called by interceptor framework prior to call to "onAlarm" method.
     * This is a standard attribute.
     */	
	public void setDataItemID(String dataItemID) {
		this.dataItemID = dataItemID;
	}

    /**
     * Called by interceptor framework prior to call to "onAlarm" method.
     * This is a standard attribute.
     */	
	public void setLevel(Integer level) {
		this.level = level;
	}

    /**
     * This method is referenced as attribute "method" in corresponding interceptor.xml tag.
     * It is called automatically by the framework after all the "in" properties have been set
     * thanks to the set method declared above.
     */	
    public void onAlarm() {
        AlarmFileManager mgr = AlarmFileManager.getInstance();
        mgr.append("\tDBID=" + resourceDBID + ";name=" + resourceName + ";type=" + resourceType + ";dataItemID=" + dataItemID + ";alarmLevel=" + level);
    }

    // resource types
    public final static int TYPE_PERSON = 1;
    public final static int TYPE_QUEUE_GROUP = 2;
    public final static int TYPE_QUEUE = 3;
    public final static int TYPE_AGENT_GROUP = 4;
    public final static int TYPE_PLACE = 5;
    public final static int TYPE_PLACE_GROUP = 6;
    public final static int TYPE_TENANT = 11;
    public final static int TYPE_ROUTING_QUEUE = 18;
    public final static int TYPE_ROUTING_POINT_GROUP = 19;
    public final static int TYPE_VIRTUAL_QUEUE = 20;
    public final static int TYPE_ROUTING_POINT = 21;

    public final static int[] RESOURCE_TYPES =
    {
        TYPE_PERSON,
        TYPE_QUEUE_GROUP,
        TYPE_QUEUE,
        TYPE_AGENT_GROUP,
        TYPE_PLACE,
        TYPE_PLACE_GROUP,
        TYPE_TENANT,
        TYPE_ROUTING_QUEUE,
        TYPE_ROUTING_POINT_GROUP,
        TYPE_VIRTUAL_QUEUE,
        TYPE_ROUTING_POINT,
    } ;

    // ObjectType names corresponding to each of the values in used in RESOURCE_TYPES
    public final static String[] OBJECT_TYPE_NAMES =  
    {   
    	"Person",
        "QueueGroup",
        "Queue",
        "AgentGroup",
        "Place",
        "PlaceGroup",
        "Tenant",
        "RoutingQueue",
        "RoutingPointGroup",
        "VirtualQueue",
        "RoutingPoint",
    };

    public static String typeToString(int type) {
    	for (int i = 0; i < RESOURCE_TYPES.length; i++) {
			if (type == RESOURCE_TYPES[i])
				return OBJECT_TYPE_NAMES[i];
		}
    	return null;
    }
}
